/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.ContractShell;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.helper.BackgroundWorker;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.ContractShell;
import net.nooj4nlp.gui.shells.GrammarEditorShell;

public class ContractShellController {
    public Grammar grammar;
    public Language lan;
    public JTextPane txtConsole;
    public StyledDocument doc;
    public Font okFont;
    public Font failureFont;
    public Font commentFont;
    public GrammarEditorShell grammarEditor;
    public boolean colored;
    public ContractShell shell;

    public ContractShellController(GrammarEditorShell gShell, Grammar g, Language l, JTextPane tc, ContractShell shell) {
        this.grammarEditor = gShell;
        this.txtConsole = tc;
        this.grammar = g;
        this.lan = l;
        this.shell = shell;
        this.shell.setTitle("Contract for " + (this.grammarEditor.getTitle().equals("Untitled") ? "" : this.grammarEditor.getTitle()));
        if (this.grammar != null && this.grammar.checkText != null && this.grammar.checkText != "") {
            this.txtConsole.setText(this.grammar.checkText);
        }
        this.commentFont = this.txtConsole.getFont();
        this.okFont = new Font(this.txtConsole.getFont().getFontName(), 1, this.txtConsole.getFont().getSize());
        Map<TextAttribute, ?> attributes = this.okFont.getAttributes();
        attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        this.failureFont = new Font(attributes);
    }

    public int checkContract() throws ClassNotFoundException, IOException {
        int grammarchecksok = 1;
        this.txtConsole.requestFocus();
        this.grammar = this.grammarEditor.getController().grammar;
        boolean projectMode = Launcher.projectMode;
        boolean backgroundWorking = Launcher.backgroundWorking;
        BackgroundWorker backgroundWorker = Launcher.backgroundWorker;
        if (this.grammar == null) {
            return -1;
        }
        RefObject<Language> lanRef = new RefObject<Language>(this.lan);
        Engine engine = new Engine(lanRef, Paths.applicationDir, Paths.docDir, Paths.projectDir, projectMode, Launcher.preferences, backgroundWorking, backgroundWorker);
        this.lan = (Language)lanRef.argvalue;
        String errmessage = null;
        RefObject<Object> errmessageRef = new RefObject<Object>(errmessage);
        if (!engine.loadResources(Launcher.preferences.ldic.get(this.lan.isoName), Launcher.preferences.lsyn.get(this.lan.isoName), true, errmessageRef)) {
            errmessage = (String)errmessageRef.argvalue;
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errmessage, "WARNING: cannot load linguistic resources for " + this.lan.isoName, 2);
        }
        if ((errmessage = this.grammar.compileAll(engine)) != null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errmessage, "NooJ Grammar Compilation Error", 0);
            return 0;
        }
        this.doc = this.txtConsole.getStyledDocument();
        Style comment = this.txtConsole.addStyle("Comment", null);
        StyleConstants.setForeground(comment, Color.black);
        StyleConstants.setFontFamily(comment, this.commentFont.getFamily());
        int lineLength = 0;
        for (int start = 0; start < this.txtConsole.getText().length(); start += lineLength + 1) {
            boolean check;
            double cpos;
            int len;
            int isol;
            int da;
            ArrayList<String> recursiveCalls;
            RefObject<Object> solvariablesRef;
            RefObject<Object> solnodesRef;
            RefObject<Object> soloutputsRef;
            RefObject<Object> solinputsRef;
            RefObject<Object> sollengthsRef;
            Gram grm;
            ArrayList solnodes;
            ArrayList solinputs;
            ArrayList solvariables;
            ArrayList soloutputs;
            ArrayList sollengths;
            HashMap<String, ArrayList<String>> simpleWordCache;
            Ntext MyText;
            ArrayList<String> sols;
            int i = 0;
            while (start + i < this.txtConsole.getText().length() && this.txtConsole.getText().charAt(start + i) != '\n') {
                ++i;
            }
            String line = this.txtConsole.getText().substring(start, start + i);
            lineLength = line.length();
            for (i = 0; i < line.length() && line.charAt(i) != '#'; ++i) {
                if (line.charAt(i) != '\\') continue;
                ++i;
            }
            if (i < line.length()) {
                line = line.substring(0, i);
            }
            if ((line = line.trim()).length() == 0) {
                this.doc.setCharacterAttributes(start, lineLength, this.txtConsole.getStyle("Comment"), true);
                continue;
            }
            boolean failure = false;
            if (line.charAt(0) == '*') {
                line = line.substring(1);
                if (this.grammar.gramType == GramType.MORPHO) {
                    sols = this.grammar.matchWord(line, engine, true, line, 0);
                    if (sols != null) {
                        Engine.filterNonWords(sols);
                    }
                    failure = sols != null && sols.size() > 0;
                } else {
                    boolean applyres;
                    MyText = new Ntext(this.lan.isoName);
                    MyText.buffer = line;
                    MyText.mft = engine.delimit(MyText);
                    simpleWordCache = new HashMap();
                    MyText.annotations = new ArrayList();
                    errmessageRef = new RefObject<String>(errmessage);
                    if (!engine.tokenize(MyText, MyText.annotations, simpleWordCache, errmessageRef)) {
                        errmessage = (String)errmessageRef.argvalue;
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errmessage, "NooJ Tokenizer Error", 0);
                        MyText.annotations = null;
                        MyText.hLexemes = null;
                        MyText.hUnknowns = null;
                        return 0;
                    }
                    simpleWordCache = null;
                    MyText.hPhrases = new HashMap();
                    if (engine.synGrms != null && engine.synGrms.size() > 0) {
                        errmessageRef = new RefObject<String>(errmessage);
                        applyres = engine.applyAllGrammars(MyText, MyText.annotations, 0, errmessageRef);
                        errmessage = (String)errmessageRef.argvalue;
                        if (!applyres && errmessage != null) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errmessage, "NooJ Syntactic Parsing Error", 0);
                            return 0;
                        }
                        if (!applyres) {
                            MyText.hPhrases = null;
                            return 0;
                        }
                        MyText.cleanupBadAnnotations(MyText.annotations);
                    }
                    if (engine.synGrms != null && engine.synGrms.size() > 0) {
                        errmessageRef = new RefObject<String>(errmessage);
                        applyres = engine.applyAllGrammars(MyText, MyText.annotations, 1, errmessageRef);
                        errmessage = (String)errmessageRef.argvalue;
                        if (!applyres && errmessage != null) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errmessage, "NooJ Syntactic Parsing Error", 0);
                            return 0;
                        }
                        if (!applyres) {
                            MyText.hPhrases = null;
                            return 0;
                        }
                    }
                    sollengths = null;
                    soloutputs = null;
                    solvariables = null;
                    solinputs = null;
                    solnodes = null;
                    grm = this.grammar.grams.get("Main");
                    if (grm == null || grm.states == null || grm.states.size() < 2) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Grammar " + this.grammar.fullName + " has no Main graph", "NooJ: no main graph in grammar", 2);
                        return -1;
                    }
                    sollengthsRef = new RefObject<Object>(sollengths);
                    solinputsRef = new RefObject<Object>(solinputs);
                    soloutputsRef = new RefObject<Object>(soloutputs);
                    solnodesRef = new RefObject<Object>(solnodes);
                    solvariablesRef = new RefObject<Object>(solvariables);
                    recursiveCalls = new ArrayList();
                    da = this.grammar.syntaxMatch(this.grammar.fullName, -1, line, 0.0, 1, MyText.mft, MyText.annotations, grm, sollengthsRef, solinputsRef, solvariablesRef, soloutputsRef, solnodesRef, true, recursiveCalls);
                    sollengths = (ArrayList)sollengthsRef.argvalue;
                    solinputs = (ArrayList)solinputsRef.argvalue;
                    soloutputs = (ArrayList)soloutputsRef.argvalue;
                    solnodes = (ArrayList)solnodesRef.argvalue;
                    solvariables = (ArrayList)solvariablesRef.argvalue;
                    if (da > 0) {
                        failure = false;
                        for (isol = 0; isol < sollengths.size(); ++isol) {
                            len = ((Double)sollengths.get(isol)).intValue();
                            if (len < line.length()) continue;
                            if (Dic.isThereALexicalConstraint((ArrayList)soloutputs.get(isol))) {
                                cpos = 0.0;
                                errmessageRef = new RefObject<String>(errmessage);
                                check = engine.processConstraints(line, MyText.mft, 1, MyText.annotations, this.grammar, (ArrayList)solinputs.get(isol), len, (ArrayList)solvariables.get(isol), cpos, (ArrayList)soloutputs.get(isol), errmessageRef);
                                errmessage = (String)errmessageRef.argvalue;
                                if (errmessage != null) {
                                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errmessage, "NooJ Constraint Processing Error", 0);
                                    return -1;
                                }
                                if (!check) continue;
                                failure = true;
                            } else {
                                failure = true;
                            }
                            break;
                        }
                    }
                }
            } else if (this.grammar.gramType == GramType.MORPHO) {
                sols = this.grammar.matchWord(line, engine, true, line, 0);
                failure = sols == null || sols.size() == 0;
            } else {
                MyText = new Ntext(this.lan.isoName);
                MyText.buffer = line;
                MyText.mft = engine.delimit(MyText);
                simpleWordCache = new HashMap<String, ArrayList<String>>();
                MyText.annotations = new ArrayList();
                errmessageRef = new RefObject<String>(errmessage);
                if (!engine.tokenize(MyText, MyText.annotations, simpleWordCache, errmessageRef)) {
                    errmessage = (String)errmessageRef.argvalue;
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errmessage, "NooJ Tokenizer Error", 0);
                    MyText.annotations = null;
                    MyText.hLexemes = null;
                    MyText.hUnknowns = null;
                    return 0;
                }
                simpleWordCache = null;
                MyText.hPhrases = new HashMap();
                if (engine.synGrms != null && engine.synGrms.size() > 0) {
                    errmessageRef = new RefObject<String>(errmessage);
                    boolean applyres = engine.applyAllGrammars(MyText, MyText.annotations, 0, errmessageRef);
                    errmessage = (String)errmessageRef.argvalue;
                    if (!applyres && errmessage != null) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errmessage, "NooJ Syntactic Parsing Error", 0);
                        return 0;
                    }
                    if (!applyres) {
                        MyText.hPhrases = null;
                        return 0;
                    }
                    MyText.cleanupBadAnnotations(MyText.annotations);
                }
                if (engine.synGrms != null && engine.synGrms.size() > 0) {
                    errmessageRef = new RefObject<String>(errmessage);
                    boolean applyres = engine.applyAllGrammars(MyText, MyText.annotations, 1, errmessageRef);
                    errmessage = (String)errmessageRef.argvalue;
                    if (!applyres && errmessage != null) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errmessage, "NooJ Syntactic Parsing Error", 0);
                        return 0;
                    }
                    if (!applyres) {
                        MyText.hPhrases = null;
                        return 0;
                    }
                }
                sollengths = null;
                soloutputs = null;
                solvariables = null;
                solinputs = null;
                solnodes = null;
                grm = this.grammar.grams.get("Main");
                if (grm == null || grm.states == null || grm.states.size() < 2) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Grammar " + this.grammar.fullName + " has no Main graph", "NooJ: no main graph in grammar", 2);
                    return -1;
                }
                sollengthsRef = new RefObject<Object>(sollengths);
                solinputsRef = new RefObject<Object>(solinputs);
                soloutputsRef = new RefObject<Object>(soloutputs);
                solnodesRef = new RefObject<Object>(solnodes);
                solvariablesRef = new RefObject<Object>(solvariables);
                recursiveCalls = new ArrayList<String>();
                da = this.grammar.syntaxMatch(this.grammar.fullName, -1, line, 0.0, 1, MyText.mft, MyText.annotations, grm, sollengthsRef, solinputsRef, solvariablesRef, soloutputsRef, solnodesRef, true, recursiveCalls);
                sollengths = (ArrayList)sollengthsRef.argvalue;
                solinputs = (ArrayList)solinputsRef.argvalue;
                soloutputs = (ArrayList)soloutputsRef.argvalue;
                solvariables = (ArrayList)solvariablesRef.argvalue;
                if (da > 0) {
                    isol = 0;
                    while (isol < sollengths.size()) {
                        len = ((Double)sollengths.get(isol)).intValue();
                        if (len < line.length()) {
                            sollengths.remove(isol);
                            solinputs.remove(isol);
                            soloutputs.remove(isol);
                            continue;
                        }
                        if (Dic.isThereALexicalConstraint((ArrayList)soloutputs.get(isol))) {
                            cpos = 0.0;
                            errmessageRef = new RefObject<String>(errmessage);
                            check = engine.processConstraints(line, MyText.mft, 1, MyText.annotations, this.grammar, (ArrayList)solinputs.get(isol), len, (ArrayList)solvariables.get(isol), cpos, (ArrayList)soloutputs.get(isol), errmessageRef);
                            errmessage = (String)errmessageRef.argvalue;
                            if (errmessage != null) {
                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errmessage, "NooJ Constraint Processing Error", 0);
                                return -1;
                            }
                            if (!check) {
                                sollengths.remove(isol);
                                solinputs.remove(isol);
                                solvariables.remove(isol);
                                soloutputs.remove(isol);
                                continue;
                            }
                        }
                        ++isol;
                    }
                    da = sollengths.size();
                }
                failure = da == 0;
            }
            Style fail = this.txtConsole.addStyle("Fail", null);
            StyleConstants.setForeground(fail, Color.red);
            StyleConstants.setFontFamily(fail, this.failureFont.getFamily());
            Style ok = this.txtConsole.addStyle("OK", null);
            StyleConstants.setForeground(ok, new Color(20, 180, 62));
            StyleConstants.setFontFamily(ok, this.okFont.getFamily());
            if (failure) {
                grammarchecksok = 0;
                this.doc.setCharacterAttributes(start, lineLength, this.txtConsole.getStyle("Fail"), true);
            } else {
                this.doc.setCharacterAttributes(start, lineLength, this.txtConsole.getStyle("OK"), true);
            }
            this.colored = true;
        }
        return grammarchecksok;
    }

    public void UncolorCheckText() {
        if (!this.colored) {
            return;
        }
        this.doc = this.txtConsole.getStyledDocument();
        Style clean = this.txtConsole.addStyle("Clean", null);
        StyleConstants.setForeground(clean, Color.black);
        this.doc.setCharacterAttributes(0, this.txtConsole.getDocument().getLength(), this.txtConsole.getStyle("Clean"), true);
        this.colored = false;
    }
}

